
#################################################
# オブジェクトへの値の代入
#################################################

x <- sin(pi/3) # x に代入
print(x) # x の値を確認
y <- cos(pi/3) # y に代入
y # print(y) と同じ，y の値を確認
z <- x - y # 計算結果を代入
(z) # print(z) と同じ，z の値を確認
(w <- x * y) # print(w <- x * y) と同じ，代入結果を表示
w # 代入結果を確認 (上と同じ値が表示される)

#################################################
# さまざまなデータ型
#################################################

### 実数("numeric")
(x <- 4) # 変数xに実数4を代入
mode(x) # データ型の確認
x^10 
x^100
x^1000 # 実数として保持できる最大値を越える
### 文字列("character")
(y <- "foo") # 文字列は ' または " で括る
mode(y) # データ型の確認
(z <- "bar") # ("foo" や "bar" は意味のない文字列として良く用いられる)
paste(y,z) # 文字列の足し算，省略時は区切り文字(separator)は " "(空白)
paste(y,z,sep="") # 区切り文字(separator)を ""(無) に指定
## y+z # 足し算はできずエラーになる
### 論理値("logical")
TRUE # 論理値(真)
T # 論理値(真)の省略形
FALSE # 論理値(偽)
F # 論理値(偽)の省略形
mode(TRUE) # データ型の確認
## 論理式の例
4 < 3 # FALSE
!(4 < 3) # TRUE. "!"は「否定」を表す
(3 + 1) != 3 # TRUE. "!="は「等しくない」を表す
(3 + 1) = 3 # エラー. "="は代入として評価される
(3 + 1) == 3 # FALSE "=="は「等しい」を表す
-3<-2 # エラー "<-"が代入として評価されてしまっている
-3 < -2 # TRUE. 空白が必要
(4 < 3) | (-3 < -2) # TRUE. "|"は「または」を表す
(4 < 3) & (-3 < -2) # FALSE. "&"は「かつ」を表す
x <- 0
x <= 0 # TRUE. "<="は「左辺は右辺以下」を表す
x >= 0 # TRUE. ">="は「右辺は左辺以下」を表す 
## 数値への変換
as.numeric(TRUE) # as.numeric は数値に変換する関数
as.numeric(F) 
TRUE + TRUE # 1 + 1 = 2
